/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.sysinfo;

import com.ibm.hwmca.base.sysinfo.SysInfoConstants;
import com.ibm.hwmca.base.sysinfo.SysInfoEcBean;
import com.ibm.hwmca.base.sysinfo.SysInfoEcData;
import com.ibm.hwmca.base.sysinfo.SysInfoEcDetailsBean;
import com.ibm.hwmca.base.sysinfo.SysInfoEcInternalCodeData;
import com.ibm.hwmca.base.sysinfo.SysInfoErrorIds;
import com.ibm.hwmca.base.sysinfo.SysInfoSubTasklet;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.sysinfo.SysInfo;
import com.ibm.hwmca.fw.sysinfo.SysInfoData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class SysInfoEcTasklet
extends SysInfoSubTasklet
implements SysInfoErrorIds,
SysInfoConstants {
    private static final String TRACE_MASKT = "HSYIETLT";
    private static final String TRACE_MASKF = "HSYIETLF";
    private static final String TRACE_MASKD = "HSYIETLD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoEcTasklet");
    private SysInfoEcInternalCodeData sysInfoData = null;

    public SysInfoEcTasklet() {
        Trace.trace(TRACE_MASKT, "<> SysInfoEcTasklet constructor");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SysInfoEcTasklet.service() request = " + request.toString());
        LocalizableText displayableName = new LocalizableText("");
        if (request.isInitialRequest()) {
            try {
                HwmcaObject targetObj = this.getSysInfoTarget(request);
                Trace.trace(TRACE_MASKF, " Getting SysInfoData for target object " + targetObj);
                this.sysInfoData = (SysInfoEcInternalCodeData)this.getSysInfoData(targetObj);
                Trace.trace(TRACE_MASKD, "got SysInfoData from target");
                Trace.trace(TRACE_MASKD, "Creating pane for object " + targetObj);
                Trace.trace(TRACE_MASKD, "Getting uiinfo for object " + targetObj);
                displayableName = this.getTargetDisplayableName(targetObj);
                if (displayableName != null) {
                    Trace.trace(TRACE_MASKD, "Displayable Name = " + displayableName);
                }
                SysInfoEcBean bean = new SysInfoEcBean(displayableName, this.sysInfoData);
                bean.setBeanName("EcBean");
                response.replace("com.ibm.hwmca.base.sysinfo.res.SystemInfoRes", "SystemInfoPagePanel", bean);
            }
            catch (IllegalArgumentException iaExc) {
                Trace.trace(TRACE_MASKF, "request.isDisposed or request.isCanceled()");
                this.logException(iaExc);
            }
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKF, "request.isDisposed or request.isCanceled()");
            response.dispose("DetailsBean");
        } else {
            String panel = (String)request.getData("panel");
            Trace.trace(TRACE_MASKF, "panel = " + panel);
            if (panel.equals("SystemInfoPagePanel")) {
                String command = (String)request.getData("command");
                if (command.endsWith("DetailsButton")) {
                    Trace.trace(TRACE_MASKF, " Details button pressed");
                    Integer rowNumber = (Integer)request.getData("row");
                    int row = rowNumber;
                    if (row >= 0) {
                        SysInfoEcInternalCodeData detailsData = new SysInfoEcInternalCodeData();
                        detailsData.setMachineType(this.sysInfoData.getMachineType());
                        detailsData.setMachineModel(this.sysInfoData.getMachineModel());
                        detailsData.setMachineSerialNumber(this.sysInfoData.getMachineSerialNumber());
                        detailsData.setMachineName(this.sysInfoData.getMachineName());
                        detailsData.setMachineDriverLevel(this.sysInfoData.getMachineDriverLevel());
                        ArrayList<SysInfoEcData> detailsList = new ArrayList<SysInfoEcData>();
                        detailsList.add(this.sysInfoData.getSysInfoEcData(row));
                        detailsData.setSysInfoEcData(detailsList);
                        SysInfoEcDetailsBean detailsBean = new SysInfoEcDetailsBean(displayableName, detailsData);
                        detailsBean.setBeanName("DetailsBean");
                        response.openModalChild("com.ibm.hwmca.base.sysinfo.res.SystemInfoRes", "CodeChangeDetailsPanel", detailsBean);
                    } else {
                        response.noAction();
                    }
                } else {
                    response.noAction();
                }
            } else {
                Trace.trace(TRACE_MASKF, "CodeChangeDetailsPanelback from details");
                response.noAction();
            }
        }
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(logInfo, 72, throwable).log();
    }

    public SysInfoData getSysInfoData(HwmcaObject targetObject) {
        Trace.trace(TRACE_MASKT, "-->SysInfoEcTasklet.getSysInfoData()");
        SysInfoData sysInfoData = null;
        SysInfo sysInfoObject = (SysInfo)((Object)targetObject);
        try {
            sysInfoData = sysInfoObject.getSysInfoData();
        }
        catch (Exception exc) {
            this.logException(exc);
        }
        Trace.trace(TRACE_MASKT, "<-- SysInfoEcTasklet.getSysInfoData()");
        return sysInfoData;
    }
}

